/**
 * Background Service Worker
 * 处理插件的后台逻辑
 */

// 监听安装事件
chrome.runtime.onInstalled.addListener(() => {
  if (chrome.sidePanel?.setPanelBehavior) {
    chrome.sidePanel.setPanelBehavior({ openPanelOnActionClick: true }).catch(() => {})
  }
  // Extension installed.
})

// 监听消息
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'GET_SETTINGS') {
    // 可以在这里处理设置相关的逻辑
    sendResponse({ success: true })
  }
  return true
})
