(function (global) {
  const defaultSettings = {
    general: {
      enabled: true,
      language: 'auto'
    },
    labels: {
      user: '用户',
      assistant: 'Assistant'
    },
    appearance: {
      position: 'right',
      width: 380,
      theme: 'auto',
      fontSize: 'medium',
      smoothScroll: true,
      scrollSpy: true,
      roleStyle: false
    },
    rules: {
      maxLength: 140,
      minLength: 5,
      showNumber: true
    },
    platforms: {
      'chat.openai.com': true,
      'chatgpt.com': true,
      'gemini.google.com': true,
      'claude.ai': true,
      'chat.deepseek.com': true,
      'www.doubao.com': true,
      'grok.com': true,
      'grok.x.ai': true,
      'x.ai': true
    },
    customSites: []
  }

  const siteLabels = {
    'chat.openai.com': { name: 'ChatGPT', icon: '🤖' },
    'chatgpt.com': { name: 'ChatGPT', icon: '🤖' },
    'gemini.google.com': { name: 'Gemini', icon: '🤖' },
    'claude.ai': { name: 'Claude', icon: '🤖' },
    'chat.deepseek.com': { name: 'DeepSeek', icon: '🤖' },
    'www.doubao.com': { name: '豆包', icon: '🤖' },
    'grok.com': { name: 'Grok', icon: '🤖' },
    'grok.x.ai': { name: 'Grok', icon: '🤖' },
    'x.ai': { name: 'Grok', icon: '🤖' }
  }

  global.ChatTOCConfig = {
    defaultSettings,
    siteLabels
  }
})(typeof globalThis !== 'undefined' ? globalThis : window)
